/*
 * Decompiled with CFR 0.152.
 */
package jace.config;

import jace.config.Configuration;
import jace.config.Name;
import jace.config.StringComponent;
import jace.core.Utility;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.ListDataListener;

class ClassSelectComponent
extends JComboBox
implements ActionListener {
    Configuration.ConfigNode node;
    String fieldName;

    @Override
    public void actionPerformed(ActionEvent e) {
        this.node.setFieldValue(this.fieldName, (Serializable)((Map.Entry)this.getSelectedItem()).getKey());
    }

    public void synchronizeValue() {
        try {
            Serializable value = this.node.getFieldValue(this.fieldName);
            if (value == null) {
                this.getModel().setSelectedItem(null);
                this.setSelectedItem(this.getModel().getSelectedItem());
            } else {
                this.getModel().setSelectedItem(value);
                this.setSelectedItem(this.getModel().getSelectedItem());
            }
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(StringComponent.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public ClassSelectComponent(Configuration.ConfigNode node, String fieldName) {
        try {
            List<Class> allClasses;
            this.node = node;
            this.fieldName = fieldName;
            Field f = node.subject.getClass().getField(fieldName);
            if (!(f.getGenericType() instanceof ParameterizedType)) {
                return;
            }
            ParameterizedType t = (ParameterizedType)f.getGenericType();
            Type type = t.getActualTypeArguments()[0];
            Class clazz = null;
            if (type instanceof Class) {
                clazz = (Class)type;
            }
            if (type instanceof WildcardType) {
                clazz = (Class)((WildcardType)type).getUpperBounds()[0];
            }
            if (!(allClasses = Utility.findAllSubclasses(clazz)).contains(null)) {
                allClasses.add(null);
            }
            final ArrayList<1> values = new ArrayList<1>();
            for (final Class c : allClasses) {
                Map.Entry<Class, String> entry = new Map.Entry<Class, String>(){

                    @Override
                    public Class getKey() {
                        return c;
                    }

                    @Override
                    public String getValue() {
                        if (c == null) {
                            return "**Empty**";
                        }
                        if (c.isAnnotationPresent(Name.class)) {
                            return c.getAnnotation(Name.class).value();
                        }
                        return c.getSimpleName();
                    }

                    @Override
                    public String setValue(String value) {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }

                    public String toString() {
                        return this.getValue();
                    }

                    @Override
                    public boolean equals(Object obj) {
                        return super.equals(obj) || obj == this.getKey() || this.getKey() != null && this.getKey().equals(obj);
                    }
                };
                values.add(entry);
            }
            Collections.sort(values, new Comparator<Map.Entry<Class, String>>(){

                @Override
                public int compare(Map.Entry<Class, String> o1, Map.Entry<Class, String> o2) {
                    if (o1.getKey() == null) {
                        return -1;
                    }
                    if (o2.getKey() == null) {
                        return 1;
                    }
                    return o1.getValue().compareTo(o2.getValue());
                }
            });
            this.addActionListener(this);
            this.setModel(new ComboBoxModel(){
                Object value;

                @Override
                public void setSelectedItem(Object anItem) {
                    if (anItem instanceof Map.Entry) {
                        this.value = anItem;
                    } else {
                        for (Map.Entry entry : values) {
                            if (!((Object)entry).equals(anItem)) continue;
                            this.value = entry;
                        }
                    }
                }

                @Override
                public Object getSelectedItem() {
                    return this.value;
                }

                @Override
                public int getSize() {
                    return values.size();
                }

                @Override
                public Object getElementAt(int index) {
                    return values.get(index);
                }

                @Override
                public void addListDataListener(ListDataListener l) {
                }

                @Override
                public void removeListDataListener(ListDataListener l) {
                }
            });
            this.synchronizeValue();
        }
        catch (NoSuchFieldException ex) {
            Logger.getLogger(ClassSelectComponent.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(ClassSelectComponent.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

